;
;  PCC - Short Name List
;
;  This file maps unit / part names to their short counterparts. It
;  replaces hullfunc.cc and the related infrastructure (Hullgen,
;  plist.q, etc.).
;
;  It supports the following ship lists (names of the archives this
;  list was compiled from). If you have a ship list not covered here,
;  feel free to add it (and send the changes to me for inclusion in
;  the master file!):
;    Altlist 2 - 6
;    Altships
;    CBList 1.0
;    C-List 2
;    DG1 Data 3
;    Fleet 2
;    GList 2.0
;    Heavy (TKF list)
;    NewHull
;    PList
;    PList 2, 2.12, 2.2, 2.3b, 2.4, 3.0beta, 3.1, 3.2
;    Penger 3.04, 3.07, 3.08
;    Psyborg
;    Ryo's Trek List
;    Standard ship list
;    TList 1.00, 1.01, 1.1
;
;  Format is "FULL NAME = Short Name". Full names are case-
;  insensitive. Care has been taken to not map two different parts
;  used by the same ship list to the same name. Of course, if you use
;  a newly-made ship list, that guarantee may be no longer met. Some
;  ship lists have identically-named ships, which will also be named
;  identically here.
;
;  You can also write "NUMBER = Short Name" to assign a short name to
;  a part specified by its number; that will set the short name no
;  matter how it's called in the current ship list. This may be useful
;  for engines, at least (for people who cannot remember whether
;  Interuniversal Drives are better or worse than Improbability
;  Drives, for example).
;
;  In case many definitions match one item, the first one will be
;  used. The only exception is that an assignment using a number takes
;  precedence over one using a name.
;
;  PCC 1.x: You can write your own assignments into a file
;  'names.usr'. That one will be processed before 'names.cc', and
;  therefore take precedence.
;
;  The data need not be in alphabetic (asciibetic) order, but it helps
;  when editing the file.
;
;  23/May/2005 by Stefan Reuther
;  01/Oct/2005 added CBList 1.0
;  01/Feb/2006 added NewHull
;  21/Jun/2007 added PList 3.1
;  12/Aug/2007 added GList 2.0
;  18/Aug/2012 added PList 3.2
;

; Short hull names. Should be 13 characters or less.
[Hulls.Short]
! BANZAI ! CLASS DESTOYER      = Banzai
ABE LINCOLN CLASS DESTROYER    = Abe Lincoln
ACHILLES DESTROYER             = Achilles
ADAMANTIUM CLASS DESTROYER     = Adamantium
ADAMMIUS CLASS LIGHT CARRIER   = Adammius
ADDER CLASS FRIGATE            = Adder
ALASKA CLASS TRANSPORT         = Alaska
ALDERAAN CLASS CORVETTE        = Alderaan
ALDERAAN CLASS DESTROYER       = Alderaan
ALDERAAN CLASS LIGHT CRUISER   = Alderaan
ALDERAAN CLASS TRANSPORT       = Alderaan
ALDERANN CLASS FRIGATE         = Alderann
ALIEN BIOSCANNER               = Alien
ALIGATOR CLASS FRIGATE         = Aligator
ALLOSAURUS CLASS CRUISER       = Allosaurus
ALLOSAURUS CLASS DESTROYER     = Allosaurus
ALTURUS CLASS ATTACK FRIGATE   = Alturus
AMBASSADOR CLASS BATTLECRUISER = Ambassador
AMBASSADOR CLASS STARSHIP      = Ambassador
AMETHIST CLASS CRUISER         = Amethist
ANACONDA CLASS FRIGATE         = Anaconda
ANDROMEDA CLASS ESCORT         = Andromeda
ANNIHILATION BATTLESHIP        = Annihilation
ANNIHILATION CLASS BATTLESHIP  = Annihilation
ANNIHILATION CLASS CUBE        = Annihilation
ANNIHILATION CLASS CUBESHIP    = Annihilation
ANNIHILATOR CLASS CUBE         = Annihilator
ANTARES CLASS FRIGATE          = Antares
APHRODITIE CLASS CRUISER       = Aphroditie
APOLLO CLASS ESCORT            = Apollo
AQUILA CLASS CRUISER           = Aquila
ARCH ENEMY CLASS BATTLESHIP    = Arch Enemy
ARCHAEOPTERIX CLASS SCOUT      = Archaeopterix
ARDRA CLASS DESTROYER          = Ardra
ARIES BULK TRANSPORT           = Aries
ARIES CLASS CARRIER            = Aries
ARIES CLASS GUNSHIP            = Aries
ARIES CLASS TRANSPORT          = Aries
ARIES DELUX TRANSPORT          = Aries Delux
ARIES TRANSPORT                = Aries
ARK II TRADER                  = Ark II
ARKHAM CLASS FRIGATE           = Arkham
ARKHAM FRIGATE                 = Arkham
ARMAGEDDON CLASS CARRIER       = Armageddon
ARMED TRANSPORT                = Armed Trns
ARMORED TRANSPORT              = Armored Trns
ARMOURED TUGBOAT               = Armored Trns
ARRAKIS CLASS TRANSPORT        = Arrakis
ARROW CLASS DESTROYER          = Arrow
ASP CLASS ESCORT               = Asp
ASSAULT CLASS GUNSHIP          = Assault
ASSIMILATION BATTLESHIP        = Assimilation
ASSIMILATION CARRIER           = Assimilation
ASSOCIATION BATTLECRAFT        = Association
ATLANTIA CLASS BATTLESTAR      = Atlantia
AURORA CLASS STAR CARRIER      = Aurora
AUTOMA BASESHIP                = Automa
AUTOMA CLASS BASESHIP          = Automa
AUTOMATON CLASS BASESHIP       = Automaton
AVENGER CLASS STAR DESTROYER   = Avenger
B'REL CLASS BIRD OF PREY       = B'Rel
B'REL CLASS BIRD-OF-PREY       = B'Rel
B'REL CLASS ESCORT             = B'Rel
B.F.C. CLASS CUBE              = B.F.C.
B11 CLASS BATTLESHIP           = B11
B11 WOQ'A' CLASS BATTLESHIP    = B11 Woq'A'
B200 CLASS PROBE               = B200
B200 HYPER PROBE               = B200 Hyper
B200 PROBE                     = B200
B222 CLASS CUBE                = B222
B222 DESTROYER                 = B222
B28 DESTROYER                  = B28
B3 CLASS BATTLE CRUISER        = B3
B41 EXPLORER                   = B41
BACKSTRIKE CLASS BATTLECRUISER = Backstrike
BALSAC CLASS CARRIER           = Balsac
BANSHEE CLASS BASESHIP         = Banshee
BANSHEE CLASS DESTROYER        = Banshee
BANSHEE CLASS ESCORT           = Banshee
BANSHEE CLASS TRANSPORT        = Banshee
BANSHEE DESTROYER              = Banshee
BARBAROSSA CLASS CRUISER       = Barbarossa
BARON CLASS ROBBER             = Baron
BARTAL CLASS ARMED TRANSPORT   = Bartal
BARZAN CLASS ALCHEMY SHIP      = Barzan
BASE SHIP                      = Base Ship
BASILISK CLASS BASESHIP        = Basilisk
BASILISK CLASS STATION         = Basilisk
BATLETH DESTROYER              = Batleth
BATTLE STATION                 = Battle Stn
BATTLE TUG                     = Battle Tug
BATTLESTAR CLASS SUPER-CARRIER = Battlestar
BEDROCK CLASS BATTLECRUISER    = Bedrock
BEEWS HOME FRIGATE             = Beews Home
BENNET CLASS SHUTTLE           = Bennet
BERSERKER CLASS STATION        = Berserker
BERYL CLASS DESTROYER          = Beryl
BEYTOR CLASS BATTELCARRIER     = Beytor
BIOCIDE CARRIER                = Biocide
BIOCIDE CLASS CARRIER          = Biocide
BIOCIDE CLASS CRUISER          = Biocide
BIOCIDE CLASS CUBE             = Biocide
BIRD OF PREY                   = Bird Of Prey
BIRD OF PREY CLASS CRUISER     = Bird Of Prey
BISMARK CLASS BATTLESHIP       = Bismark
BLACK BIRD CLASS CRUISER       = Black Bird
BLACK BIRD CLASS LIGHT CRUISER = Black Bird
BLACK DIAMOND CLASS CARRIER    = Blk Diamond
BLACKHAWK CORVETTE             = Blackhawk
BLOCKADE CRUISER               = Blockade
BLOODFANG BATTLESHIP           = Bloodfang
BLOODFANG CARRIER              = Bloodfang
BLOODFANG CLASS CARRIER        = Bloodfang
BLOODTHORNE CORVETTE           = Bloodthorne
BO'QUAH'DJI CLASS DEFENDER     = Bo'Quah'Dji
BOHEMIAN CLASS RESEARCH VESSEL = Bohemian
BOHEMIAN CLASS SURVEY SHIP     = Bohemian
BOHEMIAN ENVIRO-SHIP           = Bohemian
BOHEMIAN SUN SHIP              = Bohemian Sun
BOHEMIAN SURVEY SHIP           = Bohemian
BORALLUS CLASS CARRIER         = Borallus
BORALLUS CLASS LIGHT CARRIER   = Borallus
BORG PROBE                     = Borg Probe
BORTAS CLASS BATTLESHIP        = Bortas
BORTAS CLASS BIRD OF PREY      = Bortas
BOTHAN CLASS CRUISER           = Bothan
BOTHAN CLASS HEAVY CRUISER     = Bothan Heavy
BOTHAN CLASS LIGHT CRUISER     = Bothan Light
BOTHAN CLASS SWEEPER-DESTROYER = Bothan
BR4 CLASS GUNSHIP              = BR4
BR4 CLASS SCOUT                = BR4
BR4 DELUX SCOUT SHIP           = BR4
BR4 GUNSHIP                    = BR4
BR5 CLASS TORPEDO BOAT         = BR5
BR5 DELUX FUEL CARRIER         = BR5
BR5 KAYE CLASS TORPEDO BOAT    = BR5
BR5 KAYE TORPEDO BOAT          = BR5
BRAXIS CLASS SCOUT             = Braxis
BRIDGEKEEPER CLASS FRIGATE     = Bridgekeeper
BRIGHT HEART CLASS DESTROYER   = Bright Heart
BRIGHT HEART DESTROYER         = Bright Heart
BROO-HAH CLASS CARRIER         = Broo-Hah
BRYNHILD CLASS ESCORT          = Brynhild
BRYNHILD DELUX ESCORT          = Brynhild
BRYNHILD ESCORT                = Brynhild
BUCANEER CLASS BATTLESHIP      = Bucaneer
BUCCANEER CLASS CRUISER        = Buccaneer
BUCCANEER CLASS SPEEDBOAT      = Buccaneer
BUCCANEER RAIDER               = Buccaneer
Br5 TORPEDO BOAT               = BR5
C1 INVIDIUM CLASS BASESHIP     = C1 Invidium
C2 OMA CLASS BASESHIP          = C2 Oma
C3 IMPERIUM CLASS BASESHIP     = C3 Imperium
C7 CLASS BATTLECARRIER         = C7
C7 QAPLA' CLASS BATTLECARRIER  = C7 Qapla'
CALIFORNIA CLASS GUNSHIP       = California
CALIGULA CLASS CARRIER         = Caligula
CALRISSIAN CLASS CARRIER       = Calrissian
CAPPELAN CLASS SUPPLY FRIGATE  = Cappelan
CAPPELLAN ASSAULT VESSEL       = Cappellan
CAPRICORN CLASS CARRIER        = Capricorn
CAPRICORN CLASS DESTROYER      = Capricorn
CAPRICORN CLASS LIGHT CRUISER  = Capricorn
CARILLON CLASS ATTACK CARRIER  = Carillon
CARRACK CLASS DESTROYER        = Carrack
CARRACK CLASS LIGHT CRUISER    = Carrack
CARRACK FRIGATE                = Carrack
CAT'S PAW CLASS CRUISER        = Cat's Paw
CAT'S PAW CLASS DESTROYER      = Cat's Paw
CAT'S PAW CLASS FRIGATE        = Cat's Paw
CAT'S PAW DESTROYER            = Cat's Paw
CHE GEVARA CLASS HYPERCRUISER  = Che Gevara
CLAYMORE CLASS BATTLESHIP      = Claymore
CLONE CLASS ESCORT             = Clone
COBOL CLASS HEAVY CRUISER      = Cobol
COBOL CLASS Hvy CRUISER        = Cobol
COBOL CLASS RESEARCH CRUISER   = Cobol
COBOL CLASS RESEARCH SHIP      = Cobol
COBOL DELUX CRUISER            = Cobol Delux
COBOL RESEARCH CRUISER         = Cobol
COBRA CLASS CRUISER            = Cobra
COBRA CLASS GUNSHIP            = Cobra
COCHRANE CLASS TACHYON SHIP    = Cochrane
COLDPAIN CLASS CRUISER         = Coldpain
COLIBRY CLASS SCOUT            = Colibry
COLLECTIVE BATTLECITY          = Battlecity
COLUMBUS CLASS FRIGATE         = Columbus
COMMAND SHIP                   = Command Ship
CONSERVATOR ALCHEMY SHIP       = Conservator
CONSTELLATION CLASS CRUISER    = Constellation
CONSTELLATION CLASS DESTROYER  = Constellation
CONSTELLATION CLASS EXPLORER   = Constellation
CONSTELLATION CLASS STARSHIP   = Constellation
CONSTILATION CRUISER           = Constilation
CONSTITUTION CLASS CRUISER     = Constitution
CONSTITUTION CLASS FRIGATE     = Constitution
CONSTITUTION CLASS STARSHIP    = Constitution
COPERNICUS CLASS STATION       = Copernicus
CORAL CARRIER                  = Coral
CORELLIAN CLASS CORVETTE       = Corellian
CORELLIAN CLASS TRANSPORT      = Corellian
CORRELLIAN CLASS TRANSPORT     = Correllian
CORSAIR CLASS MARAUDER         = Corsair
CRASS CLASS FIGHTER TRANSPORT  = Crass
CRAZY HILL CLASS RAIDER        = Crazy Hill
CRETACIOUS CLASS CRUISER       = Cretacious
CROCODYLE CLASS BATTLESHIP     = Crocodyle
CROSSBOW CLASS CARRIER         = Crossbow
CRYSTAL THUNDER CARRIER        = Crys Thunder
CRYSTAL THUNDER CLASS CARRIER  = Crys Thunder
CUTLASS CLASS CRUISER          = Cutlass
CYBERNAUT BASESHIP             = Cybernaut
CYBERNAUT CLASS BASESHIP       = Cybernaut
CYBERNAUT CLASS TORPSHIP       = Cybernaut
CYBERNAUT ESCORT CARRIER       = Cybernaut
CYGNUS CLASS DESTROYER         = Cygnus
CYGNUS DESTROYER               = Cygnus
CYLON BASESTAR                 = Cy Basestar
CYLON MINELAYER                = Cy Minelayer
CYLON TANKER                   = Cylon Tanker
D'DERIDEX CLASS BATTLESHIP     = D'Deridex
D'DERIDEX CLASS FRIGATE        = D'Deridex
D'DERIDEX CLASS WARBIRD        = D'Deridex
D'TERINOK CLASS CRUISER        = D'Terinok
D1 HEXXEN CLASS BASESHIP       = D1 Hexxen
D1 MOTIVATOR CLASS ESCORT      = D1 Motivator
D19B NEFARIOUS CLASS FRIGATE   = D19b
D19B SUS'A' CLASS FRIGATE      = D19b Sus'A'
D19b NEFARIOUS CLASS DESTROYER = D19b
D19b NEFARIOUS DESTROYER       = D19b
D2 POLYGON CLASS MINE SWEEPER  = D2 Polygon
D3 CHA'DICH CLASS DESTROYER    = D3 Cha'Dich
D3 THORN CLASS DESTROYER       = D3 Thorn
D3 THORN DESTROYER             = D3 Thorn
D7 CLASS BATTLE CRUISER        = D7
D7 COLDPAIN BATTLECRUISER      = D7 Coldpain
D7 COLDPAIN CLASS CRUISER      = D7 Coldpain
D7 COLDPAIN CRUISER            = D7 Coldpain
D7a ATTACK CRUISER             = D7a Attack
D7a PAINMAKER CLASS CRUISER    = D7a Painmkr
D7a PAINMAKER CRUISER          = D7a Painmkr
DAEDALUS CLASS SCOUT           = Daedalus
DAEDALUS CLASS STARSHIP        = Daedalus
DAGGER CLASS FRIGATE           = Dagger
DALLA CLASS STAR DESTROYER     = Dalla
DARK APPRENTICE CLASS ESCORT   = Dark Appren
DARK FALCON CLASS CRUISER      = Dark Falcon
DARK KNIGHT CLASS DESTROYER    = Dark Knight
DARK SKY CLASS CARRIER         = Dark Sky
DARK WING BATTLESHIP           = Dark Wing
DARK WING CLASS BATTLESHIP     = Dark Wing
DARKLORD BATTLESTATION         = Darklord
DARKSTAR TRANSPORT             = Darkstar
DARKWING CLASS BATTLESHIP      = Darkwing
DARNOG CLASS TORPEDO BOAT      = Darnog
DE RUYTER CLASS CRUISER        = De Ruyter
DE'DERDENOK CLASS CRUISER      = De'Derdenok
DE'DERIDEX CLASS WARBIRD       = De'Deridex
DE'TERNOK CLASS SPY            = De'Ternok
DEAD PARROT CLASS FUEL CARRIER = Dead Parrot
DEATH SPECULA CLASS FRIGATE    = Death Spec
DEATH STAR                     = Death Star
DEATH STAR BASE STATION        = Death Star
DEATH STAR CLASS BATTLECARRIER = Death Star
DEATH STAR CLASS BATTLESTATION = Death Star
DEATH STAR CLASS CARRIER       = Death Star
DEATHSTAR                      = Deathstar
DEATHSTAR BATTLESTATION        = Deathstar
DEBROK CLASS SUPPLY CARRIER    = Debrok
DEEP SPACE SCOUT               = D.S.Scout
DEEP SPACE SCOUT SHIP          = D.S.Scout
DEEP SPACE TRANSPORT           = D.S.Transprt
DEEP THRUST ATTACK SHIP        = Deep Thrust
DEEPTHROAT CLASS SPY           = Deepthroat
DEFIANT CLASS DESTROYER        = Defiant
DEFIANT CRUISER                = Defiant
DEL'NORIT CLASS BATTLESHIP     = Del'Norit
DELAWARE CLASS SCOUT           = Delaware
DELAWARE CLASS SMALL TRANSPORT = Delaware
DELIRIUM CLASS BATTLESHIP      = Delirium
DEN-SHA CLASS FRIGATE          = Den-Sha
DESOLATION CLASS FRIGATE       = Desolation
DESTRUCTOR CLASS BASESHIP      = Destructor
DETH SPECULA CLASS FRIGATE     = Deth Specula
DETH SPECULA FRIGATE           = Deth Specula
DEVASTATOR CLASS CUBESHIP      = Devastator
DIAMEDES CARRIER               = Diamedes
DIAMOND * SHIP                 = Diamond
DIAMOND FLAME BATTLESHIP       = Diamd Flame
DIAMOND FLAME CLASS BATTLESHIP = Diamd Flame
DIJRA CLASS TERRAFORMER        = Dijra
DIMETRODON CLASS DESTROYER     = Dimetrodon
DIPLOMACY BATTLECRUISER        = Diplomacy
DIPLOMACY CLASS CRUISER        = Diplomacy
DIPLOMACY CRUISER              = Diplomacy
DJEROK CLASS BATTLECRUISER     = Djerok
DOMINION CLASS CRUISER         = Dominion
DRACUL CLASS PROBE             = Dracul
DRACULA CLASS JUGGERNOUGHT     = Dracula
DRAGON CLASS BASESHIP          = Dragon
DRAK-DERNAR CLASS CARRIER      = Drak-Dernar
DRAKLOR CLASS STAR GALLEON     = Draklor
DRAYMAN CLASS TRADING VESSEL   = Drayman
DREADFUL CLASS TRANSPORT       = Dreadful
DUNDEE CLASS BATTLESHIP        = Dundee
DWARF CLASS ORE EXPLORER       = Dwarf
DWARFSTAR CLASS CRUISER        = Dwarfstar
DWARFSTAR CLASS TRANSPORT      = Dwarfstar
DWARFSTAR TRANSPORT            = Dwarfstar
DYSON SPHERE CLASS TRANSPORT   = Dyson Sphere
EINSTEIN CLASS RESEARCH SHIP   = Einstein
ELIMINATOR CLASS CUBE          = Eliminator
EMERALD * SHIP                 = Emerald
EMERALD BATTLECRUISER          = Emerald
EMERALD CLASS BATTLECRUISER    = Emerald
EMERALD CLASS CRUISER          = Emerald
EMPERIAL ATTACK PROBE          = Emp Attack
EMPEROR CLASS ASSAULT CARRIER  = Emperor
ENTERPRISE CLASS CRUISER       = Enterprise
ENTERPRISE CLASS EXPLORER      = Enterprise
ERASER CLASS CUBE              = Eraser
ERASER CLASS CUBESHIP          = Eraser
ERIN TERRAFORMER               = Erin
EROS CLASS RESEARCH VESSEL     = Eros
EROS CLASS SURVEY SHIP         = Eros
EROS POLAR VESSEL              = Eros Polar
EROS RESEARCH VESSEL           = Eros
ESPRITE CLASS DESTROYER        = Esprite
EXCELCIOR CLASS CRUISER        = Excelcior
EXCELCIOR CLASS FRIGATE        = Excelcior
EXCELSIOR BATTLECRUISER        = Excelsior
EXCELSIOR CLASS BATTLESHIP     = Excelsior
EXCELSIOR CLASS DREADNOUGHT    = Excelcior
EXCELSIOR CLASS FRIGATE        = Excelsior
EXCELSIOR CLASS STARSHIP       = Excelsior
EXECUTIONER CLASS BATTLESHIP   = Executioner
EXECUTOR CL.SUPER STAR DESTR.  = Executor
EXPERIMENTAL CLASS CARRIER     = Exp. Carrier
EXPERIMENTAL CLASS EXPLORER    = Exp. Explor
EXPERIMENTAL CLASS PENETRATOR  = Exp. Penetr
EXPERIMENTAL CLASS PROBE       = Exp. Probe
EXPERIMENTAL CLASS SCOUT       = Exp. Scpit
EXPLORER CLASS CUBE            = Explorer
EXPROPIATOR CLASS FRIGATE      = Expropiator
EXTERMINATOR CLASS CUBE        = Exterminator
EXTRA LARGE FREIGHTER          = XL Freighter
EXXON VALDEZ CLASS TANKER      = Exxon Valdez
EYE OF BORG CLASS SCOUT        = Eye Of Borg
F1 FACTORY BASE                = F1 Factory
FALANX GUNSHIP                 = Falanx
FALCON ARMED MERCHANT          = Falcon
FALCON CLASS DEEP SPACE PROBE  = Falcon
FALCON CLASS ESCORT            = Falcon
FALCON CLASS PIRATE            = Falcon
FALCON CLASS TRANSPORT         = Falcon
FALCON CLASS SCOUT             = Falcon
FALCON EXPLORER                = Falcon
FALCON SUPER HYPER             = Falcon
FALCOR CLASS ESCORT            = Falcor
FAU-1 CLASS GLORY SHIP         = Fau-1
FAU-2 CLASS GLORY SHIP         = Fau-2
FCA 24 CLASS PATROL VESSEL     = FCA 24
FEARLESS WING CARRIER          = Fearless
FEARLESS WING CLS CRUISER      = Fearless
FEARLESS WING CRUISER          = Fearless
FERENGI CLASS TRADING VESSEL   = Ferengi
FIRE CLOUD CRUISER             = Fire Cloud
FIRECLOUD CLASS CHUNNEL        = Firecloud
FIRECLOUD CLASS CRUISER        = Firecloud
FIRECLOUD CLASS CUBE           = Firecloud
FIRECLOUD CLASS FRIGATE        = Firecloud
FIRECLOUD CRUISER              = Firecloud
FIRECLOUD WARP CRUISER         = Firecloud
FLINTSTONE CLASS SCOUT         = Flintstone
FOREVER KNIGHT CLASS BASESHIP  = Forever Kn
FORSYTHE JUMPSHIP              = Forsythe
FOUNDATION CLASS FREIGHTER     = Foundation
FOUNDATION CLASS SUPPLY SHIP   = Foundation
FRONT ATTACK SHIP              = Front Attack
FRONT LINE SHIP                = Front Line
FUEL REFINERY SHIP             = Fuel Ref
FUEL TANKER                    = Fuel Tanker
FUELTANKER                     = Fuel Tanker
G-459 CLASS CARRIER            = G-459
GAGARIN CLASS PROBE            = Gagarin
GALACTICA CLASS BATTLESTAR     = Galactica
GALAXY CLASS BATTLECRUISER     = Galaxy
GALAXY CLASS BATTLESHIP        = Galaxy
GALAXY CLASS DREADNAUGHT       = Galaxy
GALAXY CLASS HEAVY CRUISER     = Galaxy
GALAXY CLASS STARSHIP          = Galaxy
GALLOFREE YARDS CL. TRANSPORT  = Gallofree
GALLOFREE YARDS CLASS CARRIER  = Gallofree
GANTORIS CLASS PROBE           = Gantoris
GAURDIAN CLASS DESTROYER       = Guardian
GAURDIAN DESTROYER             = Guardian
GEMINI CLASS CARRIER           = Gemini
GEMINI CLASS TRANSPORT         = Gemini
GEMINI TRANSPORT               = Gemini
GENEROK CLASS BIRD OF PREY     = Generok
GNOM CLASS FUEL TANKER         = Gnom
GNOME CLASS FUEL TANKER        = Gnome
GOBLIN CLASS BASESHIP          = Goblin
GODFATHER CLASS CRUISER        = Godfather
GODFATHER CLASS DREADNOUGHT    = Godfather
GODZILLA CLASS BATTLESHIP      = Godzilla
GOLEM BASESHIP                 = Golem
GOLEM CLASS BASESHIP           = Golem
GORBIE BATTLECARRIER           = Gorbie
GORBIE CLASS BATTLECARRIER     = Gorbie
GUARDIAN CLASS DESTROYER       = Guardian
GUARDIAN DESTROYER             = Guardian
GUARDIAN FAST ATTACK           = Guard Attack
H-ROSS CLASS LIGHT CARRIER     = H-Ross
H-ROSS LIGHT CARRIER           = H-Ross
HALLEYS CLASS BLOCKADE RUNNER  = Halleys
HAMMER CLASS HEAVY CRUISER     = Hammer
HANSA CLASS LARGE TRANSPORT    = Hansa
HASHMAL CLASS                  = Hashmal
HAWKINGS CLASS SCIENCE VESSEL  = Hawkings
HEART OF GOLD CLASS PROBE      = Heart Of Gold
HEAVY CARGO TRANSPORT          = Heavy Cargo
HEAVY TRANSPORT                = Heavy Trns
HEDGEHOG CLASS CRUISER         = Hedgehog
HELLFIRE CLASS FRIGATE         = Hellfire
HELLHOUND CLASS INTERCEPTOR    = Hellhound
HERMES CLASS CARRIER           = Hermes
HIGH COMMAND SHIP              = High Command
HITOKIRI CLASS BASESHIP        = Hitokiri
HITOMI CLASS FUEL TANKER       = Hitomi
HOOD CLASS BATTLECRUISER       = Hood
HOPE CLASS MINESWEEPER         = Hope
HORNET CLASS CARRIER           = Hornet
HUGE FREIGHTER                 = Huge Fr
HUGH EXPLORATION VESSEL        = Hugh
HYDRA CLASS BASESHIP           = Hydra
IBUKI CLASS BASESHIP           = Ibuki
IGNETH LIGHT CARRIER           = Igneth
IKARI CLASS BASESHIP           = Ikari
ILL WIND BATTLECRUISER         = Ill Wind
ILL WIND CLASS BATTLECRUISER   = Ill Wind
ILL WIND CLASS LIGHT CRUISER   = Ill Wind
IMPERIAL BATTLECRUISER         = Imperial
IMPERIAL CLASS ESCORT          = Imp Escort
IMPERIAL CLASS STAR DESTROYER  = Imp St Dest
IMPERIAL CLASS STARDESTROYER   = Imp St Dest
IMPERIAL CRUISER               = Imp Cruiser
IMPERIAL DESTROYER             = Imp Destr
IMPERIAL ESCORT                = Imp Escort
IMPERIAL FRIGATE               = Imp Frigate
IMPERIAL GUNBOAT               = Imp Gunboat
IMPERIAL Lgt CARRIER           = Imp Lt Carr
IMPERIAL PACIFIER              = Imp Pacif
IMPERIAL PROBE DROID           = Imp Pr Droid
IMPERIAL STAR CRUISER          = Imp St Crs
IMPERIAL STAR DESTROYER        = Imp St Dest
IMPERIAL STAR ESCORT           = Imp St Esc
IMPERIAL STAR FRIGATE          = Imp St Frig
IMPERIAL STRIKE CARRIER        = Imp Str Carr
IMPERIAL SUPER COLONIZER       = Imp S Colo
INDEPENDENCE CARRIER           = Independence
INFERNO CLASS TERRAFORMER      = Inferno
INFESTATION CLASS COLONIZER    = Infestation
INSTRUCTOR CLASS BASESHIP      = Instructor
INSTRUMENTALITY BASESHIP       = Instrum
INSTRUMENTALITY CLASS BASESHIP = Instrum
INTERDICTOR WARP SHIP          = Interdictor
INTREPID CLASS CARRIER         = Intrepid
INTREPID CLASS DESTROYER       = Intrepid
INTREPID CLASS STARSHIP        = Intrepid
IONAN CLASS EXPLORER           = Ionan
IRON FELIX CLASS DESTROYER     = Iron Felix
IRON LADY CARRIER              = Iron Lady
IRON LADY CLASS FRIGATE        = Iron Lady
IRON LADY FRIGATE              = Iron Lady
IRON SLAVE BASESHIP            = Iron Slave
IRON SLAVE CLASS BASESHIP      = Iron Slave
IRON SLAVE TRANSPORT           = Iron Slave
JABBA CLASS FRIGATE            = Jabba
JACKPOT CLASS PLEASURE SHIP    = Jackpot
JADE CLASS CRUISER             = Jade
JADEITTE CLASS SCOUT           = Jadeitte
JEDI CLASS CRUISER             = Jedi
JEM-HADAR LARGE BATTLESHIP     = Jem-H Large
JEM-HADAR LIGHT ESCORT         = Jem-H Light
JI'TOK CLASS BIRD OF PREY      = Ji'Tok
JITBUG CLASS CARRIER           = Jitbug
JORELL CLASS FRIGATE           = Jorell
JOSEPH STALIN CLASS DREADMOON  = J.Stalin
JURRASIC CLASS DREADNAUGHT     = Jurrasic
K'DJIN'TOK CLASS FREIGHTER     = K'Djin'Tok
K'PA GLORY VESSEL              = K'Pa Glory
K'T'INGA CLASS BATTLE CRUISER  = K'T'Inga
K'T'INGA CLASS BATTLECRUISER   = K'T'Inga
K'TINGA DREADNAUGHT            = K'Tinga
K'VORT CLASS BIRD-OF-PREY      = K'Vort
K'VORT CLASS LIGHT CRUISER     = K'Vort
K1 DESTROYER                   = K1 Destr
KAHLESS CLASS MISSILE          = Kahless
KAMIKAZE DREADNAUGHT           = Kamikaze
KATANA CLASS DREADNOUGHT       = Katana
KATANA CLASS HEAVY CRUISER     = Katana
KATANA CLASS Hvy CRUISER       = Katana
KAYE CLASS TORPEDO BOAT        = Kaye
KEARN CLASS TROOP CARRIER      = Kearn
KEILES BATTLECRUISER           = Keiles
KERUB CLASS                    = Kerub
KHAN CLASS DESTROYER           = Khan
KHRONOS CLASS BATTLECRUISER    = Khronos
KIEV CLASS STAR DESTROYER      = Kiev
KIIjIP GUL BATTLESHIP          = Kiijip Gul
KING CONDOR CLASS BATTLESHIP   = King Condor
KING CONDOR CLASS WARBIRD      = King Condor
KITE SCOUT                     = Kite
KITTYHAWK CARRIER              = Kittyhawk
KITTYHAWK CLASS CARRIER        = Kittyhawk
KKY'TAL CLASS BATTLECARRIER    = Kky'Tal
KLIM-TAR CLASS TROOP TRANSPORT = Klim-Tar
KOLOTH CLASS LIGHT CARRIER     = Koloth
KONGO CLASS DREADNOUGHT        = Kongo
KUWAIT CLASS REFINERY          = Kuwait
LACROIX CLASS DESTROYER        = Lacroix
LADY ROYALE CLASS CARRIER      = Lady Royale
LADY ROYALE CLASS CRUISER      = Lady Royale
LADY ROYALE CRUISER            = Lady Royale
LADY ROYALE FUNCRUISER         = Lady Royale
LAFORGE CLASS TACHYON SCANNER  = Laforge
LANCER CLASS FRIGATE           = Lancer
LANCET CLASS FRIGATE           = Lancet
LANGLEY CLASS LIGHT CARRIER    = Langley
LARGE DEEP SPACE FREIGHTER     = LDSF
LARGE FREIGHTER                = Large Fr
LARGE TRANSPORT                = Large Tr
LAS-VEGAS CLASS YACHT          = Las-Vegas
LEVIATHAN CLASS DESTROYER      = Leviathan
LIBERATOR CLASS GUNSHIP        = Liberator
LIGHT CARGO TRANSPORT          = Light Trns
LIGHT TRANSPORT                = Light Trns
LITTLE JOE CLASS ESCORT        = Little Joe
LITTLE JOE ESCORT              = Little Joe
LITTLE PEST CLASS ESCORT       = Little Pest
LITTLE PEST ESCORT             = Little Pest
LIZARD CLASS CRUISER           = LCC
LIZARD CRUISER                 = Lizard Cr
LOKI CLASS DESTROYER           = Loki
LOKI CLASS FRIGATE             = Loki
LOKI CLASS FUEL TANKER         = Loki
LOKI CLASS HUNTER              = Loki
LOKI DELUX DESTROYER           = Loki Delux
LOKI DESTROYER                 = Loki
LONERIDER SCOUT                = Lonerider
LONG RANGE SCOUT               = LongRange Sct
LONGBOW CLASS SUPPLY CARRIER   = Longbow
LRG D. S. FREIGHTER            = LDSF
LUMBERJACK CLASS SCOUT         = Lumberjack
LURSA CLASS BATTLECARRIER      = Lursa
M. FURLAN CLASS CRUISER        = M. Furlan
MADONNZILA CARRIER             = Madonnzila
MADONNZILA CLASS CARRIER       = Madonnzila
MADONZILLA CLASS CARRIER       = Madonzilla
MAGELLAN CLASS SCOUT           = Magellan
MANTA CARRIER                  = Manta
MANTICORE CLASS BASESHIP       = Manticore
MANTICORE CLASS FLAK BATTERY   = Manticore
MAQUIS RAIDER                  = Maquis
MARCON TRADER                  = Marcon
MATRIX CLASS BASESHIP          = Matrix
MAUSH BATTLECRUISER            = Maush
MECHA-GODZILLA CLASS CRUISER   = Mecha-Godzil
MECHANICON CLASS BASESHIP      = Mechanicon
MED D. S. FREIGHTER            = MDSF
MEDIUM CARGO TRANSPORT         = Medium Trns
MEDIUM DEEP SPACE FREIGHTER    = MDSF
MEDIUM FREIGHTER               = Medium Fr
MEDIUM MERCHANTMAN             = Medium
MEDIUM TRANSPORT               = Medium Trns
MENACE CLASS SCOUT             = Menace
MENHUNTER CLASS INTERCEPTOR    = Menhunter
MERCHAK CLASS FRIGATE          = Merchak
MERCUR CLASS HEAVY ESCORT      = Mercur
MEREK CLASS CARRIER            = Merek
MERLIN ALCHEMY SHIP            = Merlin
MERLIN CLASS ALCHEMY SHIP      = Merlin
MESOMORF CLASS EXPLORER        = Mesomorf
MESOMORF CLASS SCOUT           = Mesomorf
METALIC MENACE CLASS BASESHIP  = Metalic
METEOR BLOCKADE RUNNER         = Meteor
METEOR CLASS BLOCKADE RUNNER   = Meteor
METEOR CLASS SPEEDBOAT         = Meteor
METTALICA CLASS LIGHT CARRIER  = Mettalica
MIG CLASS SCOUT                = Mig Scout
MIG SCOUT                      = Mig Scout
MILLENIUM FALCON               = Mil Falcon
MINNASOTA CLASS BATTLESHIP     = Minnasota
MIRACULIX CLASS REFINERY SHIP  = Miraculix
MIRAI CLASS DESTROYER          = Mirai
MIRANDA CLASS RESEARCH VESSEL  = Miranda
MIRANDA CLASS STARSHIP         = Miranda
MIRANDA CLASS TERRAFORMER      = Miranda
MISSOURI BATTLESHIP            = Missouri
MISSOURI CLASS BATTLESHIP      = Missouri
MOLLARI CLASS TORP TRANSPORT   = Mollari
MON CALAMARI CLASS CARRIER     = Mon Calamari
MON CALAMARI CLASS CRUISER     = Mon Calamari
MON...BOBBY CLASS FIGHTER TRA  = Mon...Bobby
MONCALAMARI CLASS CARRIER      = Moncalamari
MONCALAMARI CRUISER            = Moncalamari
MONCALAMARI HEAVY CARRIER      = Monc Heavy
MONMOTHMA CLASS CARRIER        = Monmothma
MORDEK CLASS FIGHTER TRANSPORT = Mordek
MORDEN CLASS RAIDER            = Morden
MORTAK CLASS SCOUT             = Mortak
MOSCOW CLASS STAR ESCORT       = Moscow
MOSCOW STAR ESCORT             = Moscow
MUGEN CLASS BASESHIP           = Mugen
MULTI-PURPOSE CUBE             = M.P. Cube
MULTIPURPOSE SCOUT             = M.P. Scout
N'TANG ASSAULT SHIP            = N'Tang
NA'MOGH CLASS BIRD OF PREY     = Na'Mogh
NAGUS CLASS CARRIER            = Nagus Carr
NAGUS CLASS TRADING VESSEL     = Nagus Trader
NCC-1701A CLASS CRUSIER        = NCC-1701A
NEBULA CLASS CRUISER           = Nebula
NEBULA CLASS DESTROYER         = Nebula
NEBULA CLASS LIGHT CRUISER     = Nebula
NEBULA CLASS STARSHIP          = Nebula
NEBULA CRUISER                 = Nebula
NEBULON 'B' ATTACK CARRIER     = Nebulon 'B'
NEBULON A ATTACK FRIGATE       = Nebulon A
NEBULON-B CLASS FRIGATE        = Nebulon-B
NEBULON-B CLASS STAR FRIGATE   = Nebulon-B
NEEDLE CLASS SCOUT             = Needle
NEFARIOUS CLASS DESTROYER      = Nefarious
NEFARIOUS CLASS GUNBOAT        = Nefarious
NEFARIOUS CLASS SCOUT          = Nefarious
NEFARIOUS DESTROYER            = Nefarious
NERVANA CLASS TRANSPORT        = Nervana
NEUTRONIC FUEL CARRIER         = N.F.C.
NEUTRONIC FUEL TANKER          = N.F.T.
NEUTRONIC REFINERY             = N.Refinery
NEUTRONIC REFINERY SHIP        = N.Refinery
NEW BERLIN CLASS DESTROYER     = New Berlin
NEW ORLEANS CLASS FRIGATE      = New Orleans
NEXUS FRIGATE                  = Nexus
NIAGARA CLASS DESTROYER        = Niagara
NIGHTSHADE CLASS CRUISER       = Nightshade
NINTENDO CLASS GAME CUBE       = Nintendo
NOCTURNE CLASS DESTROYER       = Nocturne
NOCTURNE CLASS TORPEDO BOAT    = Nocturne
NOCTURNE DESTROYER             = Nocturne
NOSFERATU CLASS CUBESHIP       = Nosferatu
NOVA CLASS BATTLESHIP          = Nova
NOVA CLASS DREADNOUGHT         = Nova
NOVA CLASS SUPER-DREADNOUGHT   = Nova
NOVA DREADNOUGHT               = Nova
NOVA SUPER-DREADNOUGHT         = Nova
NURAL PLEASURE VESSEL          = Nural
OASIS CLASS TERRAFORMER        = Oasis
OBERON IV REFINERY SHIP        = Oberon IV
OBERTH CLASS STARSHIP          = Oberth
OBERTH CLASS SURVEY SHIP       = Oberth
OBSIDIAN EYE CLASS PROBE       = Obsidian Eye
OFAN CLASS                     = Ofan
OGLA PRIDE CLASS BATTLECARRIER = Ogla Pride
OGRE CLASS BASESHIP            = Ogre
OHIO CLASS FRIGATE             = Ohio
OMNIBUS PLANETOID              = Omnibus
ONYX CLASS FRIGATE             = Onyx
ONYX FIRE FRIGATE              = Onyx
ONYX FRIGATE                   = Onyx
ONYX SCIENTIST                 = Onyx
OPAL CLASS DESTROYER           = Opal
OPAL CLASS SCOUT               = Opal
OPAL CLASS TORPEDO BOAT        = Opal
OPAL TORPEDO BOAT              = Opal
ORC CLASS BASESHIP             = Orc
ORDOS CLASS TRANSPORT          = Ordos
ORION CLASS CARRIER            = Orion Carrier
ORION TRADER                   = Orion Trader
OSPREY CLASS CARRIER           = Osprey
OUTRIDER CLASS SCOUT           = Outrider
OUTRIDER SCOUT                 = Outrider
PAGH CLASS TRANSPORT           = Pagh
PAINMAKER CLASS CRUISER        = Painmaker
PAINMAKER D7a                  = Painmaker D7a
PALLEON CLASS GUNBOAT          = Palleon
PARADIGM CLASS CRUISER         = Paradigm
PARADISE CLASS TERRAFORMER     = Paradise
PARINOL CLASS ASSAULT CRUISER  = Parinol
PARTIZAN CLASS CARRIER         = Partizan
PATRIOT CLASS CARRIER          = Patriot
PATRIOT CLASS LIGHT CARRIER    = Patriot
PATRIOT LIGHT CARRIER          = Patriot
PATROL SHIP                    = Patrol
PAWN CLASS BASESHIP            = Pawn
PAWN DELUX BASESHIP            = Pawn Delux
PAWN RESEARCH SHIP             = Pawn
PEACE DEATH CLASS CUBE         = Peace Death
PEARL * SHIP                   = Pearl
PEGASUS CLASS BATTLESTAR       = Pegasus
PENGUIN CLASS SELF DESTROYER   = Penguin
PERN CLASS MINELAYER           = Pern
PHOENIX CLASS DESTROYER        = Phoenix
PHOENIX CLASS TRANSPORT        = Phoenix
PHOENIX CLASS TRANSPORTER      = Phoenix
PIRATE POWER TUG               = Pirate
PL21 CLASS PROBE               = PL21
PL21 HYPER PROBE               = PL21
PL21 PROBE                     = PL21
PLATINUM CLASS FRIGATE         = Platinum
PLYMOUTH CLASS SUPER FREIGHTER = Plymouth
POCKET CLASS CUBE              = Pocket
POSITRONIC CLASS DESTROYER     = Positronic
POULTRY CLASS DESTROYER        = Poultry
POWERSLAVE CLASS BASESHIP      = Powerslave
PP'NAL CLASS MINELAYER         = Pp'Nal
PRESTIGE INTERCEPTOR           = Prestige
PRESTO CLASS REFINERY SHIP     = Presto
PRIYUNG HEAVY CRUISER          = Priyung
PROCTOR CLASS DESTROYER        = Proctor
PROMETHEUS CLASS DESTROYER     = Prometheus
PROMETHEUS CLASS TERRAFORMER   = Prometheus
PTERADACTIL CLASS CARRIER      = Pteradactil
PUNISHER CLASS DESTROYER       = Punisher
PURE PROFIT CLASS CASINO BOAT  = Pure Profit
PYTHON CLASS CARRIER           = Python
PYTHON CLASS ESCORT            = Python
Q TANKER                       = Q Tanker
Q'YUL ESCORT                   = Q'Yul
QAIBE' CLASS FRIGATE           = Qaibe'
QU - TANKER                    = Qu Tanker
QUI-QUOG CLASS EXPLORER        = Qui-Quog
QUIETUS BATTLE CRUISER         = Quietus
QUIETUS CLASS CRUISER          = Quietus
QUIETUS CLASS CUBE             = Quietus
QUIETUS CRUISER                = Quietus
RAIDEN CLASS ESCORT            = Raiden
RAKSHIR BIRD OF PREY           = Rakshir
RAPIER CLASS LIGHT CRUISER     = Rapier
RAPIER CLASS Lgt CRUISER       = Rapier
RAPTOR CLASS CRUISER           = Raptor
RAPTOR CLASS LANDING VESSEL    = Raptor
RAVAGER CLASS CUBE             = Ravager
RAVEN CLASS CUBESHIP           = Raven
REBEL ASSAULT CARRIER          = Rebel Assault
REBEL ASSAULT CLASS CARRIER    = Rebel Assault
REBEL ASSAULT FRIGATE          = Rebel Assault
RED WIND CARRIER               = Red Wind
RED WIND CLASS CARRIER         = Red Wind
RED WIND HEAVY CARRIER         = Red Wind
RELIANT DESTROYER              = Reliant
REMUS CLASS CRUISER            = Remus
RENDAR CLASS ESCORT            = Rendar
RENN CLASS ESCORT              = Renn
REPTILE CLASS DESTROYER        = Reptile
REPTILE CLASS FRIGATE          = Reptile
REPTILE CLASS SCOUT            = Reptile
REPTILE DESTROYER              = Reptile
RESOLUTE BATTLECRUISER         = Resolute
RESOLUTE CLASS BATTLECRUISER   = Resolute
REVOLUTION CLASS ASSAULT SHIP  = Revolution
RHODAN CLASS DESTROYER         = Rhodan
RIGEL CLASS DESTROYER          = Rigel
RIGEL CLASS STARSHIP           = Rigel
RIO GRANDE CLASS RUNABOUT      = Rio Grande
RISING STAR CLASS ESCORT       = Rising Star
ROBO TANKER                    = Robo Tanker
ROMULAN TRANSPORT              = Romulan Trns
ROOK ATTACK CARRIER            = Rook Attack
ROSS CLASS LIGHT FRIGATE       = Ross
RU25 CLASS GUNBOAT             = RU25
RU25 CLASS SCOUT               = RU25
RU25 GUNBOAT                   = RU25
RUBIKHAN DESTROYER             = Rubikhan
RUBY * SHIP                    = Ruby
RUBY CLASS CRUISER             = Ruby
RUBY CLASS DESTROYER           = Ruby
RUBY CLASS LIGHT CRUISER       = Ruby
RUBY LIGHT BATTLECARRIER       = Ruby
RUBY LIGHT CRUISER             = Ruby
RUSH CLASS HEAVY CARRIER       = Rush
RUSH HEAVY CARRIER             = Rush
RUSTBUCKET CLASS TRANSPORT     = Rustbucket
S1 SEEKER CLASS BIO CRUISER    = S1 Seeker
SABER CLASS FRIGATE            = Saber
SABER CLASS MINESWEEPER        = Saber
SABER DELUX FRIGATE            = Saber
SABER FRIGATE                  = Saber
SABRE CLASS BATTLECRUISER      = Sabre
SABRE CLASS FRIGATE            = Sabre
SAGE CLASS CARRIER             = Sage
SAGE CLASS FRIGATE             = Sage
SAGE FRIGATE                   = Sage
SAGITARIUS CLASS TRANSPORT     = Sagitarius
SAGITTARIUS CLASS CARRIER      = Sagittarius
SAGITTARIUS CLASS TRANSPORT    = Sagittarius
SAGITTARIUS TRANSPORT          = Sagittarius
SAPHIRE * SHIP                 = Saphire
SAPHIRE CLASS BATTLECRUISER    = Saphire
SAPHIRE CLASS DESTROYER        = Saphire
SAPHIRE CLASS HEAVY CRUISER    = Saphire
SAPPHIRE CLASS BATTLECRUISER   = Sapphire
SARATOGA CLASS ESCORT          = Saratoga
SAURIAN BATTLECRUISER          = Saurian
SAURIAN BATTLE CRUISER         = Saurian
SAURIAN CLASS BATTLECRUISER    = Saurian
SAURIAN CLASS CRUISER          = Saurian
SAURIAN CLASS HEAVY CRUISER    = Saurian
SAURIAN CLASS LIGHT CRUISER    = Saurian
SAURIAN LIGHT CRUISER          = Saurian
SAVVY CLASS ACADEMY FRIGATE    = Savvy
SCAVENGER CLASS CUBE           = Scavenger
SCORPIUS CLASS ATTACK CARRIER  = Scorpius
SCORPIUS CLASS BATTLESTAR      = Scorpius
SCORPIUS CLASS CARRIER         = Scorpius
SCORPIUS CLASS LIGHT CARRIER   = Scorpius
SCORPIUS CLASS MEDIUM CARRIER  = Scorpius
SCORPIUS LIGHT CARRIER         = Scorpius
SCOUT SHIP                     = Scout Ship
SE-OH-NE-JAY CLASS BATTLESHIP  = Se-Oh-Ne-Jay
SEEBEK BIRD OF PREY            = Seebek
SEED SHIP                      = Seed Ship
SEGURATTA LIGHT CRUISER        = Seguratta
SEKSWATCH CLASS CRUISER        = Sekswatch
SELA CLASS SPY SHIP            = Sela
SELA'TOK CLASS SPY SHIP        = Sela'Tok
SELEK CLASS CARRIER            = Selek
SERAPH CLASS                   = Seraph
SERPENT CLASS ESCORT           = Serpent
SERPENT CLASS GUNBOAT          = Serpent
SERPENT CLASS SCOUT            = Serpent
SERPENT ESCORT                 = Serpent
SHADOW CLASS CARRIER           = Shadow
SHADOW CLASS CRUISER           = Shadow
SHADOW CLASS DESTROYER         = Shadow
SHADOW STAR CARRIER            = Shadow
SHATHRA CLASS LIGHT CARRIER    = Shathra
SHRIKE CARRIER                 = Shrike
SHUTTLERAFT CLASS SCOUT        = Shuttleraft
SILICATE CLASS CARRIER         = Silicate
SILICON AVATAR CLASS CARRIER   = Silicon Avt
SIRIUS CYBERNETICS FREIGHTER   = Sirius
SITH CLASS SCOUT               = Sith
SITH LORD CLASS ASSAULT BOAT   = Sith Lord
SKY GARNET CLASS DESTROYER     = Sky Garnet
SKY GARNET DESTROYER           = Sky Garnet
SKYFIRE CLASS CRUISER          = Skyfire
SKYFIRE CRUISER                = Skyfire
SMALL DEEP SPACE FREIGHTER     = SDSF
SMALL FREIGHTER                = Small Frg
SMALL TRANSPORT                = Small Trns
SON OF MOGH CLASS BASESHIP     = Son Of Mogh
SON OF MOGH CLASS BATTLESHIP   = Son Of Mogh
SOO'WIKLAH CLASS BATTLECRUISER = Soo'Wiklah
SORYUU CLASS BASESHIP          = Soryuu
SOUKU CLASS MINELAYER          = Souku
SOVEREIGN CLASS BATTLESHIP     = Sovereign
SOVEREIGN CLASS STARSHIP       = Sovereign
SPARROW CLASS BIRD-OF-PREY     = Sparrow
SPARROW CLASS ESCORT           = Sparrow
SPEAR OF DESTINY               = Spear Of Dest
SPIONAGE SCOUT                 = Spy Scout
STAR CRUISER                   = Star Cruiser
STAR DESTROYER                 = Star Destr
STAR FRIGATE                   = Star Frigate
STARGAZER CLASS EXPLORER       = Stargazer
STEEL SOLDIER CLASS CARRIER    = Steel Sold
STINGER CLASS ESCORT           = Stingr Esc
STINGER CLASS GUNBOAT          = Stingr GBoat
STINGER CLASS GUNSHIP          = Stingr GShip
STINGER TRANSPORT              = Stingr Trans
STRIKE CLASS CARRIER           = Strike
STUCCHIO C-1 CLASS TRANSPORT   = Stucchio C-1
STUCCHIO C-1 CLASS(MODIFIED)   = Stu C-1(Mod)
SUFFREN CLASS CRUISER          = Suffren
SUP TRANS FREIGHTER            = Super Fr
SUPER CLASS STAR DESTROYER     = S.Star Dest
SUPER COLONIZER                = S.Colonizer
SUPER DEEP SPACE FREIGHTER     = Super Fr
SUPER FREIGHTER                = Super Fr
SUPER STAR CARRIER             = S.S.Carrier
SUPER STAR CLASS DESTROYER     = Super Star
SUPER STAR CRUISER             = S.S.Cruiser
SUPER STAR DESTROYER           = S.S.Destr
SUPER STAR DESTROYER B         = S.S.Destr B
SUPER STAR FRIGATE             = S.S.Frigate
SUPER STARDESTROYER            = S.S.Destr
SUPER TRANSPORT FREIGHTER      = Super Fr
SUPERHAWK CLASS ASSAULTCARRIER = Superhawk
SUPPLY CARRIER                 = Supply Carr
SUPRISE CLASS FUEL TANKER      = Suprise
SWIFT HEART CLASS SCOUT        = Swift Heart
SWIFT HEART SCOUT              = Swift Heart
T-REX BATTLESHIP               = T-Rex
T-REX CLASS BATTLESHIP         = T-Rex
T-REX CLASS HEAVY CARRIER      = T-Rex
TACHIKOMA CLASS BASESHIP       = Tachikoma
TALARIAN CLASS MERCHANTMAN     = Talarian
TALSHIAR BATTLECRUISER         = Talshiar
TANAKA CLASS DESTROYER         = Tanaka
TARDIS CLASS LIGHT CARRIER     = Tardis
TARIK-NOR CLASS CRUISER        = Tarik-Nor
TARKHIK CLASS DESTROYER        = Tarkhik
TARKHIK CLASS ESCORT           = Tarkhik
TARKIN CLASS LIGHT CARRIER     = Tarkin
TARSHISH CLASS                 = Tarshish
TAURUS CLASS GUNBOAT           = Taurus
TAURUS CLASS SCOUT             = Taurus
TAURUS SCOUT                   = Taurus
TEROK'NOR CLASS REFINERY       = Terok'Nor
TEXAS CLASS REFINERY SHIP      = Texas
THOLIAD BATTLECRUISER          = Tholiad
THOLIAN TERROR CARRIER         = Tholian
THOR CLASS FRIGATE             = Thor
THOR FRIGATE                   = Thor
THOR HEAVY CRUISER             = Thor
THOR POCKET BATTLESHIP         = Thor Pocket
THORN CLASS DESTROYER          = Thorn
THORN DESTROYER                = Thorn
THRAWN CLASS STAR DESTROYER    = Thrawn
THUNDERBIRD CLASS BATTLESHIP   = Thunderbird
TIE CLASS INTERCEPTOR          = Tie
TIGER CLASS BATTLECARRIER      = Tiger
TIGNA CLASS BATTLESHIP         = Tigna
TOPAS CLASS SUPPLYING BASESHIP = Topas
TOPAZ CLASS GUNBOAT            = Topaz
TOPAZ CLASS SUPPLYING BASESHIP = Topaz
TOPAZ CLASS TRAPPER            = Topaz
TOPEZ CLASS GUN BOAT           = Topez
TOPEZ CLASS GUNBOAT            = Topez
TOPEZ GUNBOAT                  = Topez
TOPSID CLASS FRIGATE           = Topsid
TRANQUILITY CLASS CRUISER      = Tranquility
TRANQUILITY CRUISER            = Tranquility
TROLL CLASS ESCORT             = Troll
TROLL CLASS MINELAYER          = Troll
TRULOOK CRUISER                = Trulook
TTPEZ CLASS RUNNER             = Ttpez
U'TUN GLORY VESSLE             = U'Tun Glory
UNDEAD CLASS SCOUT             = Undead
UNIVERSAL COLONIZER            = Univ Colon
UNIVERSAL SHUTTLE              = Univ Shuttle
UNKNOWN                        = Unknown
VACHON CLASS SCOUT             = Vachon
VALCORT ARMOURED TRANSPORT     = Valcort
VALDEZ CLASS FUEL CARRIER      = Valdez
VALDEZ FUEL CARRIER            = Valdez
VALIANT WIND CARRIER           = Valiant Wind
VALIANT WIND CLASS CARRIER     = Valiant Wind
VANDELAY CLASS GUNBOAT         = Vandelay
VARYAG CLASS STAR CRUISER      = Varyag
VEIL CLASS TRANSPORT           = Veil
VELOCIRAPTOR CLASS CARRIER     = Velociraptor
VENDETTA CLASS CARRIER         = Vendetta
VENDETTA CLASS FRIGATE         = Vendetta
VENDETTA FRIGATE               = Vendetta
VENOM CLASS FRIGATE            = Venom
VENTROO CLASS CARRIER          = Ventroo
VENTROO CLASS CUBESHIP         = Ventroo
VER-DIK CLASS FREIGHTER        = Ver-Dik
VERIN'DA'NAL CLASS CRUISER     = Verin'Da'Nal
VERINOR CLASS BATTLECARRIER    = Verinor
VERN DAHL CLASS DESTROYER      = Vern Dahl
VERNOK LOON CLASS CARRIER      = Vernok Loon
VHOTAHN CLASS TERRAFORMER      = Vhotahn
VICTORIOUS BATTLESHIP          = Victorious
VICTORIOUS CLASS BATTLESHIP    = Victorious
VICTORY CLASS STAR DESTROYER   = Victory
VICTORY CLASS STARDESTROYER    = Victory
VIL-CHA CLASS ESCORT           = Vil-Cha
VIRGINIA CLASS FREIGHTER       = Virginia
VIRGO BATTLESTAR               = Virgo
VIRGO CLASS BATTLESTAR         = Virgo
VIRGO CLASS RESEARCH CRUISER   = Virgo
VIRGO CLASS RESEARCH SHIP      = Virgo
VIRGO CLASS TRANSPORT          = Virgo
VOGON CLASS CONSTRUCTOR SHIP   = Vogon Ctor
VOGON CLASS LIGHT CRUISER      = Vogon
VOR'CHA CLASS ATTACK CRUISER   = Vor'Cha
VOR'CHA CLASS BATTLECRUISER    = Vor'Cha
VOYAGER CLASS EXPLORATION VESL = Voyager
VOYAGER CLASS RESEARCH CRUISER = Voyager
VULCAN CLASS BATTLECRUISER     = Vulcan
WARAXE CLASS LIGHT CRUISER     = Waraxe
WARAXE CLASS Lgt CRUISER       = Waraxe
WARBIRD                        = Warbird
WARBIRD CLASS DESTROYER        = Warbird
WARDEN CLASS LIGHT CARRIER     = Warden
WARSPITE CLASS BATTLESHIP      = Warspite
WATCHER CLASS GUNSHIP          = Watcher
WATCHER CLASS SCOUT            = Watcher
WATCHER SCOUT                  = Watcher
WAYLAND CLASS PROBE            = Wayland
WERWOLF CLASS DESTROYER        = Werwolf
WHITE FALCON CLASS CRUISER     = White Falcon
WHITE FALCON CRUISER           = White Falcon
WHITE HEART CLASS WARBIRD      = White Heart
WHITE STAR CRUISER             = White Star C
WINSTON LIGHT CARRIER          = Winston
WOOKEY CLASS ESCORT            = Wookey
WORM CLASS SCOUT               = Worm
WUNDERWAFFE CLASS DESTROYER    = Wunderwaffe
WYRM CLASS SCOUT               = Wyrm
XENOCIDE CLASS CUBESHIP        = Xenocide
XENOCIDE CLASS DESTROYER       = Xenocide
XENOMORF CLASS FRIGATE         = Xenomorf
XXULI LIGHT CRUISER            = Xxuli
Y'MIR CLASS TERRAFORMER        = Y'Mir
YAMATO CLASS BATTLECRUISER     = Yamato
YOLEOND BATTLESHIP             = Yoleond
YORKTOWN CLASS CRUISER         = Yorktown
YULAN BIRD OF PREY             = Yulan
Z'HA'DUM CLASS CARRIER         = Z'Ha'Dum
ZEEFRAM CLASS DEFENDER         = Zeefram
ZEK CLASS CARRIER              = Zek
nGNAR CORSAIR                  = nGnar

; Short beam names, should be 3 characters.
[Beams.Short]
ATG-Irregulator      = Atg
Black hole Device    = BHD
Blaster              = Bla
Converter Cannon     = Con
Desintegrator        = DIn
Disintegrator        = DIn
Disruptor            = Dis
Electron Ram         = ERa
Electrostatic Blastr = Ele
Fusion Beam          = Fus
Gamma Laser          = Gam
Gamma Ray            = Gam
Gen Code Destructor  = Gen
HEAVYPHASOR          = HPh
Heavy Blaster        = HBl
Heavy Disruptor      = HDi
Heavy Phaser         = HPh
Hvy Blaster          = HBl
Hyperinmestron       = Hyp
Impulse Radiator     = Imp
Inpotron Cannon      = Inp
Interval Cannon      = Int
ION GUN              = IoG
Ion Blaster          = Ion
Ion Cannon           = Ion
Kill-O-Zap           = Kil
Laser                = Las
Laser Cannon         = Las
Laser Mk 1           = La1
Laser Mk 2           = La2
Light Phaser         = LPh
Medium Phaser        = MPh
MEGABOLT CANNON      = MBC
Megadeath Ray        = MDR
Meson Cannon         = Mes
Microwave Laser      = Mic
Mk 2 Laser           = Mk2
Multitraf Spiral     = Mul
NEUTRON PELLET GUN   = Neu
Neutron Beam         = Neu
PARTICLE BEAM        = Par
PHASOR               = Pha
PULSE PHASER         = Pul
Phased Polaron       = PPo
Phased Polaron Beam  = PPo
Phaser               = Pha
Phaser Mk 1          = Ph1
Phaser Mk2           = Ph2
Plasma Beam          = Pla
Plasma Bolt          = Pla
Plasma Cannon        = Pla
Positron Beam        = Pos
Pulse Laser          = Pul
Rail Gun             = Rai
Sunjammer            = Sun
TRI FOCUS PLASMA     = Tri
Turbo Laser          = Tur
Turbolaser Battery   = Tur
Type 2 Disruptor     = T2D
Type 6 Disruptor     = T6D
Type III Phaser      = T3P
Type V Phaser        = T5P
Ultra Phaser         = UPh
X-Ray Laser          = XRa
Zeno Beam            = Zen

; Short torp names, should be 3 chars.
[Torps.Short]
Annihilator VI       = An6
Annihilator VII      = An7
Annihilator VIII     = An8
Annihilator X        = AnX
ANTI-MATTER BOMB     = Ant
Antimatter Bomb      = Ant
Antimatter Torp      = Ant
Apocolypse           = Apo
Arkon Bomb           = Ark
Armageddon           = Arm
BLACK HOLE PROJECTOR = BHP
CATALAN INVERTER     = Cat
Death Blossom        = Dea
Dumbfire             = Dum
Fission Bomb         = Fis
Fusion Bomb          = Fus
GRAPE SHOT           = Gra
Gamma Bomb           = Gam
Gamma Torpedo        = Gam
Graviton Bomb        = Gra
Graviton Torp        = Gra
HARPOON              = Har
HELLFIRE TORPEDO     = Hel
HERCULAR MISSILE     = Her
Hell Hammer          = HHa
Hydrogen Torp        = Hyd
Initial Bomb         = Ini
Irridium Bomb        = Irr
Katalysator Bomb     = Kat
M/AM Warhead         = MAM
MERCULITE MISSILE    = Mer
Mark 1 Photon        = Mk1
Mark 2 Photon        = Mk2
Mark 3 Photon        = Mk3
Mark 4 Photon        = Mk4
Mark 5 Photon        = Mk5
Mark 6 Photon        = Mk6
Mark 7 Photon        = Mk7
Mark 8 Photon        = Mk8
Mesonic Bomb         = Mes
Mk 1 Photon          = Mk1
Mk. 1 Photon         = Mk1
Mk. 2 Photon         = Mk2
Mk. 3 Photon         = Mk3
Mk. 4 Photon         = Mk4
Mk. 5 Photon         = Mk5
Mk. 6 Photon         = Mk6
Mk1 Space Mine       = Mi1
Mk2 Space Mine       = Mi2
NEUTRONIUM BOMB      = Neu
Nuclear              = Nuc
Nuclear Missile IX   = NM9
Nuclear Missile X    = NMX
OMEGA-V BOMB         = Om5
Paralyso-Matic Bomb  = Par
Paratron Transformer = Par
Photon Torp          = Pho
Photon Torp. Mk1     = Ph1
Photon Torp. Mk2     = Ph2
Photon Torp. Mk3     = Ph3
Photon Torpedo       = Pho
Photon mk.1          = Ph1
Photon mk.2          = Ph2
Photon mk.3          = Ph3
Photon mk.4          = Ph4
Photon mk.5          = Ph5
Photonen Torpedo     = Pho
Plasma torpedo       = Pla
Proto Matter Warhea  = Pro
Proton Torp          = Pro
Proton torp.         = Pro
Proton torpedo       = Pro
Quantum Torp         = Qua
Quantum Torp Mk1     = Qu1
Quantum Torp Mk2     = Qu2
Reaper Rocket IX     = RR9
Reaper Rocket X      = RRX
Selphyr-Fataro-Dev.  = SFD
Singularity Torp     = Sin
Space Rocket         = Spa
THERMONUCLEARS       = The
Telemo Bomb          = Tel
Temporal Torp        = Tem
ZEON MISSILE         = Zeo

; Engine names. Should be 5 chars or less.
[Engines.Short]
ANTI-MATTER DRIVE    = AMD
Bistromatic Drive    = BMD
Dimesexta Drive      = Dimes
Dimetrans Drive      = Dimet
Enerpsi Drive        = Enerp
FUSION DRIVE         = FusD
HYPER THRUST DRIVE   = HypT
Heavy Nova Drive 6   = HND-6
HeavyNova Drive 6    = HND-6
Hyper Drive 8        = HD-8
IMPROVED WARP DRIVE  = ImprW
INTERPHASED DRIVE    = IntrD
Improbability Drive  = Impro
Impulse Drive        = Impul
Interuniversal Drive = Inter
Linear Drive         = LinD
Metagrav Drive       = Metag
NOVA DRIVE           = Nova
Nova Drive 5         = Nova5
Q-Warp               = QWarp
QUANTAM DRIVE        = Quant
Quantam Drive 7      = Quan7
STAR DRIVE           = StarD
STARDRIVE            = StarD
STARDRIVE 5          = SD-5
STARDRIVE 6          = SD-6
STARDRIVE 7          = SD-7
SUBLIGHT ENGINE      = Subl
Space Warp Gen 8     = SWG-8
Space Warp Generator = SWG
Star Drive 1         = SD-1
Star Drive 2         = SD-2
Star Drive 3         = SD-3
StarDrive 1          = SD-1
StarDrive 2          = SD-2
StarDrive 3          = SD-3
StarDrive 8          = SD-8
StarDrive 9          = SD-9
StarDrive A          = SD-A
StarDrive B          = SD-B
Super Star Drive 4   = SSD-4
SuperStarDrive 4     = SSD-4
SuperTranswarp       = STW
Transferdim Drive    = TrfdD
TransshieldGenerator = TrShG
Transwarp Drive      = TWD
WARP DRIVE           = WarpD
